/*
 * WebDict
 *
 * Copyright (C) 1997  Mikkun. All rights reserved.
 *
 * japan.c
 *   EUC,JIS,SJIS text convert module.
 *
 * History:
 *   Ver1.00  1997/09/07  ꡼ǤȤ.
 *   Ver0.01  1997/09/05  Created by Mikkun.
 */
#ident  "@(#) WebDict: Ver1.00 1997/09/07 japan.c"
#ident  "@(#) WebDict: Copyright (C) 1997 Mikkun. All rights reserved."

/*
 * إåե
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*
 * ޥ
 */
#define SIZE_BUFF 256;

/* 
 * ѿ
 */
static unsigned char *out_buff = NULL;    /* ѴʸǼ */
static int out_size = 0;    /* Хåեꤹ롣 */
static int out_len  = 0;    /* ʸǼֹꤹ롣 */


/*
 * ХȽϥХåե¸
 */
static void
out (char c)
{
    /* Хåե­ʤгĥ */
    if (out_len >= out_size - 1)
    {
        out_size += SIZE_BUFF;
        out_buff = realloc (out_buff, out_size);
        if (out_buff == NULL)
        {
            fprintf (stderr, "out: Can't perform malloc(%d).\n", out_size);
            exit (1);
        }
    }
 
    /* Хåե˳Ǽ */
    out_buff[out_len] = c;
    out_len++;
    out_buff[out_len] = '\0';

    return;
}

/*
 * EUCɤJISɤѴ
 */
unsigned char *
euc2jis (unsigned char *in)
{
    int in_jp = 0;

   /* ǼХåե */
    out_buff = NULL;
    out_size = 0;
    out_len  = 0;

    /* ʸַ֤ */
    while (*in)
    {
        if (*in < 0x80)
        {
	    if(*in == 0x0A)
		{
		    out(0x0D);
		    out(0x0A);
		}
            if (in_jp)
            {
                out (0x1b);	/* ASCII⡼ɡȾѵˤΥץ  */
                out (0x28);
                out (0x4a);
                in_jp = 0;    /* ƬʸASCIIλϥץ󥹤Ĥʤ */
            }
            out (*in); in++;
        }
        else
        {
            if (!in_jp)
            {
                out (0x1b);	/* ʸˤΥץ */
                out (0x24);
                out (0x40);
                in_jp = 1;
            }
            out (*in - 0x80); in++;
            out (*in - 0x80); in++;
        }
    }

    /* ǽäASCII⡼ɤᤷƤ */
    if (in_jp)
    {
        out (0x1b);	/* KANJI OUT */
        out (0x28);
        out (0x4a);
    }

    /* ü */
    out('\0');
    return (out_buff);
}

/*
 * JISɤShift-JISɤѴ
 */
unsigned char *
jis2sjis (unsigned char *in)
{
    unsigned char c1, c2;
    unsigned char row_offset, cell_offset;

   /* ǼХåե */
    out_buff = NULL;
    out_size = 0;
    out_len  = 0;

    /* ʸַ֤ */
    while (*in)
    {
        if (*in == 0x1b)	/* ݤʺǽϴǻϤޤäƤ뤫 */
        {
            in += 3;
            while (*in != 0x1b)
            {
                c1 = *in++;
                c2 = *in++;
                row_offset  = c1 < 0x5f ? 0x70 : 0xb0;
                cell_offset = c1 % 2 ? (c2 > 0x5f ? 0x20 : 0x1f) : 0x7e;
                out (((int)(c1 + 1) >> 1) + row_offset);
                out (c2 + cell_offset);
            }
            in += 3;
        }
        else			/* ASCIIʸ */
        {
            out (*in); in++;
        }
    }

    /* ü */
    out ('\0');
    return (out_buff);
}

/*
 * eof
 */

